var diffValue;
var chart = {
  // 初始
  init: function(divEl) {
    let _outWidth = divEl.getAttribute('width');
    let _outHeight = divEl.getAttribute('height');
    diffValue = parseInt(_outWidth) / parseInt(_outHeight);

    // 最外层svg
    let _globalSvg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    _globalSvg.setAttribute('id', 'global-svg');
    _globalSvg.setAttribute('width', _outWidth);
    _globalSvg.setAttribute('height', _outHeight);
    _globalSvg.setAttribute('viewBox', `0 0 ${ _outWidth} ${_outHeight}`);
    _globalSvg.setAttribute('preserveAspectRatio', 'none');
    _globalSvg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    _globalSvg.setAttribute('xmlns:xlink', 'http://www.w3.org/1999/xlink');
    _globalSvg.setAttribute('baseProfile', 'full');
    divEl.appendChild(_globalSvg);

    // svg内中的g,标签
    let _outG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    _outG.setAttribute('id', 'out-g');
    _outG.setAttribute('transform', `translate(0, ${_outHeight}) scale(1, -1)`);  // 进行翻转
    _globalSvg.appendChild(_outG);

    //创建放入底部x轴数值的g标签
    let _xG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    _xG.setAttribute('id', 'x-g');
    _globalSvg.appendChild(_xG);

    // 在g创建需要包裹住所需内容的g标签
   // 1、创建放入左侧y轴横线及数值的g标签
   let _yG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _yG.setAttribute('id', 'y-g');
   _outG.appendChild(_yG);


   // 2、创建放入线段数值的g标签
   let _pathG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathG.setAttribute('id', 'path-g');
   _outG.appendChild(_pathG);

   // 3、创建放入折线图竖线
   let _pathDeployLineG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathDeployLineG.setAttribute('id', 'path-deploy-line-g');
   _outG.appendChild(_pathDeployLineG);


   // 4、创建放入折线图背景色数值
   let _pathBgG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathBgG.setAttribute('id', 'path-bg-g');
   _outG.appendChild(_pathBgG);

   // 5、创建hover时选择区块的g
   let _hoverG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _hoverG.setAttribute('id', 'hover-g');
   _outG.appendChild(_hoverG);

   // 6、创建折线图背景颜色的样式g
   let _pathBgColor = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathBgColor.setAttribute('id', 'path-bg-color-g');
   _outG.appendChild(_pathBgColor);

   // 7、创建放入折线图圆点
   let _pathDeployCircleG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathDeployCircleG.setAttribute('id', 'path-deploy-circle-g');
   _outG.appendChild(_pathDeployCircleG);

   return {setOption: setOption};
  },
}

var _option;
// 根据接收数据，渲染出样式
function setOption(option) {
  _option = option;

  let svg_width = document.querySelector('#global-svg').viewBox.baseVal.width;
  let svg_height = document.querySelector('#global-svg').viewBox.baseVal.height;
  let _y = option.yAxis;  // 左侧y轴样式
  let _x = option.xAxis; // 底部x轴
  let _aroundX = _x.outpadding ? _x.outpadding : 12;   // x轴距离页面上下左右距离
  let _aroundInX = _x.inpadding? _x.inpadding : 5; // 折线距离左右线段距离
  let _aroundY = _y.padding ? _y.padding + _y.font.fontSize : 5 + _y.font.fontSize; // y轴距离页面边距左右距离
  let _aroundTextY = _y.padding ? _y.padding : 5; // y轴文字距离页面左侧的距离
  let _diffV = _y.max / (_y.totalLine - 1); // 计算y轴数据之间差值
  let _x_startX = _aroundX + _aroundY + _aroundInX;  // x轴底部开始位置
  let x_padding = (svg_width - _aroundX * 2 - _aroundY - _aroundInX * 2) / (option.xAxis.data.length - 1);  // 每段数据间距
  let y_padding = (svg_height - _aroundX - _x.font.fontSize) / option.yAxis.totalLine;

  console.log(y_padding, '------padding', _aroundX)

  // y轴展示
  for (var i = 0; i < _y.totalLine; i++) {

    // 数值展示
    let _yP = (i * 1 + 1) * y_padding;
    let _yText = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    _yText.setAttribute('text-anchor', 'middle');
    _yText.setAttribute('alignment-baseline', 'middle');
    _yText.setAttribute('x', _aroundTextY);
    _yText.setAttribute('y', _yP);
    _yText.setAttribute('transform', `translate(0, ${_yP * 2 }) scale(1, -1)`);
    _yText.classList.add('y-text');
    _yText.setAttribute('style', `font-size:${_countFont(_y.font.fontSize)};fill:${_y.font.color}`);
    _yText.appendChild(document.createTextNode( Math.round(i * _diffV * 100) / 100));
    document.querySelector('#y-g').appendChild(_yText);

    // 横线
    let _yLine = document.createElementNS('http://www.w3.org/2000/svg', 'line');
    _yLine.setAttribute('x1', _aroundY + _aroundX);
    _yLine.setAttribute('y1', _yP); // y轴需要计算
    _yLine.setAttribute('x2', svg_width - _aroundX); // svg宽度 - x轴padding
    _yLine.setAttribute('y2', _yP); // y轴需要计算
    _yLine.setAttribute('stroke', `${_y.yLineColor}`);
    _yLine.setAttribute('stroke-width', '1');
    document.querySelector('#y-g').appendChild(_yLine);
  }

  // 底部x轴样式
  for (let m in _x.data) {
    console.log(_aroundX, '-----_aroundX')

    let _xText = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    _xText.setAttribute('text-anchor', 'middle');
    _xText.setAttribute('alignment-baseline', 'middle');
    _xText.setAttribute('x', _x_startX);
    _xText.setAttribute('y', svg_height - y_padding + _x.font.fontSize + _aroundX);
    _xText.setAttribute('id', 'x-text-'+m);
    _xText.classList.add('x-text');
    _xText.setAttribute('style', `font-size:${_countFont(_x.font.fontSize)};fill:${_x.font.color}`);
    _xText.appendChild(document.createTextNode(_x.data[m]));
    document.querySelector('#x-g').appendChild(_xText);

    // 折线竖线分块，实现hover选择功能
    let verticalLine = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    let endX = _x_startX + x_padding; // 计算hover区域的轴
    let endY = (_y.totalLine)* y_padding;
    let _vPath = (`M${_x_startX},${y_padding} L${_x_startX},${endY} ${endX},${endY} ${endX},${y_padding}Z`);

    verticalLine.setAttribute('fill', 'transparent');
    verticalLine.setAttribute('d',_vPath);
    verticalLine.setAttribute('class', m)
    document.querySelector('#hover-g').appendChild(verticalLine);
    verticalLine.addEventListener('mouseout', function() {
      hoverMouseout(event, m, option);
    }, false);  // 鼠标移出
    verticalLine.addEventListener('mouseover', function(){
      hoverMouseover(event, m, option);
    }, false);  // 鼠标移入

    _x_startX += x_padding;
  }


  // 折线图数值及样式
  for(let l in option.series) {
    let path_data = [];
    let start_x = _aroundX + _aroundY + _aroundInX; // 折线图数据开始值，y轴间距 + x轴距离y轴的间距
    for (let s in option.series[l].data) {
      let _data = option.series[l].data;
      let _startY = y_padding * (_data[s] / _diffV) + y_padding;
      path_data.push(`${start_x},${_startY}`);

      // 折线图上圆点显示
      // hover时，竖线显示, 只生成一次，因为他们是一样的
      if (l == 0) {
        let hoverLine = document.createElementNS('http://www.w3.org/2000/svg', 'line');
        hoverLine.setAttribute('x1', start_x);
        hoverLine.setAttribute('y1', y_padding); // y轴需要计算
        hoverLine.setAttribute('x2', start_x);
        hoverLine.setAttribute('y2', (_y.totalLine) * y_padding); // y轴需要计算
        hoverLine.setAttribute('stroke', option.series[l].hoverStyle.linestroke);
        hoverLine.setAttribute('stroke-width', '1');
        hoverLine.classList.add('hover-line');
        hoverLine.classList.add('hover-line-'+s);
        document.querySelector('#path-deploy-line-g').appendChild(hoverLine);
      }

      // 折线hover后，圆点放大
      let hoverCircle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
      hoverCircle.setAttribute('cx', start_x);
      hoverCircle.setAttribute('cy', _startY)
      hoverCircle.setAttribute('r', 5);
      hoverCircle.setAttribute('stroke', option.series[l].hoverStyle.circlestroke);
      hoverCircle.setAttribute('stroke-width', 3);
      hoverCircle.setAttribute('fill', 'none');
      hoverCircle.classList.add('hover-circle');
      hoverCircle.classList.add('hover-circle-'+s);
      document.querySelector('#path-deploy-circle-g').appendChild(hoverCircle);


      // 折线上设置圆点
      let circle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
      circle.setAttribute('cx', start_x);
      circle.setAttribute('cy', _startY);
      circle.setAttribute('r', 3);
      circle.setAttribute('stroke', 'white');
      circle.setAttribute('stroke-width', 1);
      circle.setAttribute('fill', option.series[l].normalStyle.circlestroke);
      circle.setAttribute('transform-origin', `${start_x} ${_startY}`);  // 圆点中心位置
      circle.style.setProperty('--delay', `${(3 * parseInt(s) / _data.length)}s`);
      circle.classList.add('point');
      document.querySelector('#path-deploy-circle-g').appendChild(circle);

      start_x += x_padding;
    }

    // 创建折线图及背景
    createPathLine(option, l, path_data, y_padding);
  }
}

// 鼠标移出
function hoverMouseout(event, s, option) {
  // console.log('鼠标移出', s)
  let _allEl = document.querySelectorAll('.hover-circle-' +s);
  for (var i = 0; i < _allEl.length; i++) {
    _allEl[i].style.setProperty('opacity', 0);
  }
  document.querySelector('.hover-line-' +s).style.setProperty('opacity', 0);
  document.querySelector('#x-text-'+s).style.setProperty('fill', option.xAxis.font.color);
}

// 鼠标移入
function hoverMouseover(event, s) {
  // console.log(s,'鼠标移入', event);
  let _allEl = document.querySelectorAll('.hover-circle-' +s);
  for (var i = 0; i < _allEl.length; i++) {
    _allEl[i].style.setProperty('opacity', 1);
  }
  document.querySelector('.hover-line-' +s).style.setProperty('opacity', 1);
  document.querySelector('#x-text-'+s).style.setProperty('fill', option.xAxis.font.hoverFontColor);
}


/*
* 创建折线图
* option: 数据图参数
* l: series的index
* data: 组装数据点
* bottomY: y轴每个线段之间间距
*/
function createPathLine(option, l, data, bottomY) {

  // 折线是否平滑
  let _issmooth = option.series[l].smooth ? true : false;
  let _prefix = _issmooth ? 'R' : 'L';

  let _isPathBg = option.series[l].normalStyle.pathBgColor &&  option.series[l].normalStyle.pathBgColor != '' ? true : false;

  let _gPathC = document.createElementNS('http://www.w3.org/2000/svg', 'g');
  _gPathC.classList.add('path-g-container');
  _gPathC.setAttribute('id', 'path-g-container-'+l);
  document.querySelector('#path-g').appendChild(_gPathC);

  // 折线展示
  let line = document.createElementNS('http://www.w3.org/2000/svg', 'path');
  line.setAttribute('id', 'line-'+l);
  line.classList.add('line');
  line.setAttribute('stroke-width', '2');
  line.setAttribute('fill', 'none');
  line.setAttribute('style', `stroke:${option.series[l].normalStyle.linestroke};animation-delay:.${option.animateTime}s`);

  let _new_path_data = data;
  let startPath = _new_path_data.slice(0, 1);
  _new_path_data.splice(0, 1);

  let _line_path = (`M${startPath.join(' ')} ${_prefix}${_new_path_data.join(' ')}`);
  let _newPath = _issmooth ? parsePath(_line_path) : _line_path;
  line.setAttribute('d', _newPath);
  document.querySelector('#path-g-container-'+l).appendChild(line);

  // 折线图背景色数值
  if (_isPathBg) {
    let line_bg = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    line_bg.setAttribute('id', 'line-1-'+l);
    line_bg.classList.add('line-1');
    line_bg.setAttribute('fill', `${'url("#line-bg-'+l+'")'}`);
    let path_end = _new_path_data[_new_path_data.length - 1].split(',')
    let path_start = startPath.join(',').split(',');
    // 组新数据
    let bg_path = (`M${startPath.join(' ')} ${_prefix}${_new_path_data.join(' ')} H${path_end[0]}V${bottomY}H${path_start[0]}Z`);
    let _newBgPath = _issmooth ? parsePath(bg_path) : bg_path;
    line_bg.setAttribute('d', _newBgPath);
    document.querySelector('#path-bg-g').appendChild(line_bg);


    // 创建折线图显示背景颜色标签
    // let _linearTime = setTimeout(() => {
      creatLinearGradient('line-bg-'+l, option.series[l].normalStyle.pathBgColor, l);
    //   clearTimeout(_linearTime);
    // }, 1000 * 3);
  }

  // //计算长度，实现动画
  let strokeLength = Math.ceil(document.querySelector('#line-'+l).getTotalLength());  //获取折线图的长度
  document.querySelector('#path-g-container-'+l).style.setProperty('--stroke-length', strokeLength);
  document.querySelector('#global-svg').classList.add('animate');
}

// 背景色显示的标签位置
function creatLinearGradient(id, bgColor, l) {
  // 背景外层
  let _linear = document.createElementNS('http://www.w3.org/2000/svg', 'linearGradient');
  _linear.setAttribute('id', id);
  _linear.setAttribute('x1', '0%');
  _linear.setAttribute('x2', '0%');
  _linear.setAttribute('y1', '0%');
  _linear.setAttribute('y2', '100%');
  // _linear.setAttribute('style', 'fill-opacity: 0');
  document.querySelector('#path-bg-color-g').appendChild(_linear);

  // 背景颜色
  let _colorData = [
    {offset: "0", stopColor: bgColor, stopOpacity: '0'},
    {offset: "1", stopColor: bgColor, stopOpacity: '0'}
  ];

  for (let k in _colorData) {
    let _stop = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
    _stop.setAttribute('offset', _colorData[k].offset);
    _stop.setAttribute('stop-color', _colorData[k].stopColor);
    _stop.setAttribute('stop-opacity', _colorData[k].stopOpacity);
    _stop.setAttribute('id', 'stop-'+l+'-'+k);
    _linear.appendChild(_stop);

  }


  let _bgAnimate1 = document.createElementNS('http://www.w3.org/2000/svg', 'animate');
  _bgAnimate1.setAttribute('attributeName', 'y1');
  _bgAnimate1.setAttribute('from', '1');
  _bgAnimate1.setAttribute('to', '0');
  // _bgAnimate.setAttribute('path', path);
  _bgAnimate1.setAttribute('dur', '0.3s');
  _bgAnimate1.setAttribute('begin', `${option.animateTime}s`);
  _bgAnimate1.setAttribute('repeatCount', '1');
  _bgAnimate1.setAttribute('fill', 'freeze');
  _linear.appendChild(_bgAnimate1);

  // 背景动画
  let _bgAnimate = document.createElementNS('http://www.w3.org/2000/svg', 'animate');
  _bgAnimate.setAttribute('attributeName', 'stop-opacity');
  _bgAnimate.setAttribute('from', '0.5');
  _bgAnimate.setAttribute('to', '0');
  _bgAnimate.setAttribute('dur', '0s');
  _bgAnimate.setAttribute('begin', `${option.animateTime}s`);
  _bgAnimate.setAttribute('repeatCount', '1');
  _bgAnimate.setAttribute('fill', 'freeze');
  // _stop.appendChild(_bgAnimate);
  document.querySelector('#stop-'+l +'-1').appendChild(_bgAnimate);

}

// 数字换算
function _countFont(fontSize) {
  let _diff = diffValue;
  // return fontSize / _diff;
  return fontSize;
}


//计算path值
function parsePath( data ) {

  var pathArray = [];
  var lastX = "";
  var lastY = "";
  var d = data.toString();

  if ( -1 != d.search(/[rR]/) ) {
    // no need to redraw the path if no Catmull-Rom segments are found

    // split path into constituent segments
    var pathSplit = d.split(/([A-Za-z])/);
    for (var i = 0, iLen = pathSplit.length; iLen > i; i++) {
      var segment = pathSplit[i];

      // make command code lower case, for easier matching
      // NOTE: this code assumes absolution coordinates, and doesn't account for relative command coordinates
      var command = segment.toLowerCase()
      if ( -1 != segment.search(/[A-Za-z]/) ) {
        var val = "";
        if ( "z" != command ) {
          i++;
          val = pathSplit[ i ].replace(/\s+$/, '');
        }

        if ( "r" == command ) {
          // "R" and "r" are the a Catmull-Rom spline segment

          var points = lastX + "," + lastY + " " + val;

          // convert Catmull-Rom spline to B茅zier curves
          var beziers = catmullRom2bezier( points );
          //insert replacement curves back into array of path segments
          pathArray.push( beziers );
        } else {
          // rejoin the command code and the numerical values, place in array of path segments
          pathArray.push( segment + val );

          // find last x,y points, for feeding into Catmull-Rom conversion algorithm
          if ( "h" == command ) {
            lastX = val;
          } else if ( "v" == command ) {
            lastY = val;
          } else if ( "z" != command ) {
            var c = val.split(/[,\s]/);
            lastY = c.pop();
            lastX = c.pop();
          }
        }
      }
    }

    // recombine path segments and set new path description in DOM
    // path.setAttribute( "d", pathArray.join(" ") );
    return pathArray;
  }
}


function catmullRom2bezier( points ) {
  // alert(points)
  var crp = points.split(/[,\s]/);

  var d = "";
  for (var i = 0, iLen = crp.length; iLen - 2 > i; i+=2) {
    var p = [];
    if ( 0 == i ) {
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
      p.push( {x: parseFloat(crp[ i + 4 ]), y: parseFloat(crp[ i + 5 ])} );
    } else if ( iLen - 4 == i ) {
      p.push( {x: parseFloat(crp[ i - 2 ]), y: parseFloat(crp[ i - 1 ])} );
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
    } else {
      p.push( {x: parseFloat(crp[ i - 2 ]), y: parseFloat(crp[ i - 1 ])} );
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
      p.push( {x: parseFloat(crp[ i + 4 ]), y: parseFloat(crp[ i + 5 ])} );
    }

    // Catmull-Rom to Cubic Bezier conversion matrix
    //    0       1       0       0
    //  -1/6      1      1/6      0
    //    0      1/6      1     -1/6
    //    0       0       1       0

    var bp = [];
    bp.push( { x: p[1].x,  y: p[1].y } );
    bp.push( { x: ((-p[0].x + 6*p[1].x + p[2].x) / 6), y: ((-p[0].y + 6*p[1].y + p[2].y) / 6)} );
    bp.push( { x: ((p[1].x + 6*p[2].x - p[3].x) / 6),  y: ((p[1].y + 6*p[2].y - p[3].y) / 6) } );
    bp.push( { x: p[2].x,  y: p[2].y } );

    d += "C" + bp[1].x + "," + bp[1].y + " " + bp[2].x + "," + bp[2].y + " " + bp[3].x + "," + bp[3].y + " ";
  }

  return d;
}
