## 引入chart

通过标签方式直接引入创建好的chart

```
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <!-- 引入 charts 文件 -->
    <script src="chart.js"></script>
</head>
</html>
```

## 绘制图表
在绘图前我们需要为 chart 准备一个具备高宽的 DOM 容器

```
<body>
	<!-- 为 ECharts 准备一个具备大小（宽高）的 DOM 必须为数字 -->
	<div id = 'main' width = '425' height = '236'></div>
</body>
```

然后就可以通过chart.init 方法初始化一个chart 实例并通过 setOption 方法生成一个折线图。下面完整代码

```
<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title></title>
    <link rel="stylesheet" href="./chart/chart.css">
  </head>
  <body>
    <div id="main" style="width: 600px;height:400px;"></div>
  </body>
  <script type="text/javascript" src = './chart/chart.js'></script>
  <script type="text/javascript">
  	// 基于准备好的dom,初始化chart实例
    var myChart = chart.init(document.getElementById('main'));

    // 指定图表的配置项和数据
    var option = {
    animateTime: 3, // 折线图动画时间
     // x轴配置信息
	 xAxis: {
		data: ['Mon','Tue','Wed','Thu','Fri','Sat', 'Sun'],
		font: {
		 fontSize: 4,
		 color: 'rgba(40,40,40,0.3)',
		 hoverFontColor: 'rgba(40,40,40,1)', // 鼠标hover时，字体颜色
		},
    outpadding: 10, // x轴距离页面左右上下之间间距
    inpadding: 5, // 折线图距离线段的左右之间间距
	 },

  	 yAxis: {
	    font: {
	      fontSize: 4,
	      color: 'rgba(40,40,40,0.3)'
	    },
	    yLineColor: '#F6F6F6',  // y轴线段颜色
	    min: 0, // 最小值
	    max: 1, // 最大值
	    totalLine: 5, // 需要线段数量
      padding: 10, // y轴之间间距
    },

    series: [
        {
          type: 'line',  // chart的类型 line: 折线图
          smooth: true, // 是否是平滑曲线
          data: [0.9,0.4,0.7,0.9,0.26,1,0.54],
          normalStyle: { // 折线图常规样式
            linestroke: '#953C96',  // 折线图线段颜色
            circlestroke: '#953C96',  // 折线图点颜色
            pathBgColor: '#953C96', // 非必填项，如果没有这个参数，说明不需要折线阴影
          },
          hoverStyle: {  // 折线hover时配置
            circlestroke: '#DFC4DF',  // 点外侧颜色
            linestroke: '#f6f6f6' // 折线图hover时，竖线颜色
          }
        },
        {
          type: 'line',
          smooth: true, // 是否是平滑曲线
          data: [0.8,0.1,0.7,1,0.26,0.3,0.9],
          normalStyle: {
            linestroke: '#2A9BC5',
            circlestroke: '#2A9BC5',
            pathBgColor: '#2A9BC5'
          },
          hoverStyle: {
            circlestroke: '#87CEFA',
            linestroke: '#f6f6f6'
          }
        },
        {
          type: 'bar', // bar: 柱状图
          data: [0.75,0.1,0.7,1,0.26,0.3,0.9],
          normalStyle: { // 柱状图常规样式
            backgroundColor: '#953C96',  // 柱状图颜色
            width: 14, // 柱状宽度
            borderRadius: 3 // 柱状圆角
          },
        }
      ]
    }
    // 使用刚指定的配置项和数据显示图表。
    myChart.setOption(option);
  </script>
</html>
```
