var diffValue;
var _outId;
var chart = {
  // 初始
  init: function(divEl) {
    let _outWidth = divEl.getAttribute('width');
    let _outHeight = divEl.getAttribute('height');
    _outId = divEl.getAttribute('id');
    // console.log(divEl.getAttribute('id'), '==========', divEl)
    diffValue = parseInt(_outWidth) / parseInt(_outHeight);

    // 最外层svg
    let _globalSvg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    _globalSvg.setAttribute('id', 'global-svg-'+_outId);
    _globalSvg.classList.add('global-svg');
    _globalSvg.setAttribute('width', _outWidth);
    _globalSvg.setAttribute('height', _outHeight);
    _globalSvg.setAttribute('viewBox', `0 0 ${ _outWidth} ${_outHeight}`);
    _globalSvg.setAttribute('preserveAspectRatio', 'none');
    _globalSvg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    _globalSvg.setAttribute('xmlns:xlink', 'http://www.w3.org/1999/xlink');
    _globalSvg.setAttribute('baseProfile', 'full');
    divEl.appendChild(_globalSvg);

    // svg内中的g,标签
    let _outG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    _outG.setAttribute('id', 'out-g');
    _outG.setAttribute('transform', `translate(0, ${_outHeight}) scale(1, -1)`);  // 进行翻转
    _globalSvg.appendChild(_outG);

    //创建放入底部x轴数值的g标签
    let _xG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    _xG.setAttribute('id', 'x-g');
    _globalSvg.appendChild(_xG);

    // 在g创建需要包裹住所需内容的g标签
   // 1、创建放入左侧y轴横线及数值的g标签
   let _yG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _yG.setAttribute('id', 'y-g');
   _outG.appendChild(_yG);


   // 2、创建放入线段数值的g标签
   let _pathG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathG.setAttribute('id', 'path-g');
   _outG.appendChild(_pathG);

   // 3、创建放入折线图竖线
   let _pathDeployLineG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathDeployLineG.setAttribute('id', 'path-deploy-line-g');
   _outG.appendChild(_pathDeployLineG);


   // 4、创建放入折线图背景色数值
   let _pathBgG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathBgG.setAttribute('id', 'path-bg-g');
   _outG.appendChild(_pathBgG);

   // 5、创建hover时选择区块的g
   let _hoverG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _hoverG.setAttribute('id', 'hover-g');
   _outG.appendChild(_hoverG);

   // 6、创建折线图背景颜色的样式g
   let _pathBgColor = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathBgColor.setAttribute('id', 'path-bg-color-g');
   _outG.appendChild(_pathBgColor);

   // 7、创建放入折线图圆点
   let _pathDeployCircleG = document.createElementNS('http://www.w3.org/2000/svg', 'g');
   _pathDeployCircleG.setAttribute('id', 'path-deploy-circle-g');
   _outG.appendChild(_pathDeployCircleG);

   return {setOption: setOption};
  },
}

var _option;
// 根据接收数据，渲染出样式
function setOption(option, outId) {
  _option = option;
  let svg_width = document.querySelector('#global-svg-'+_outId).viewBox.baseVal.width;
  let svg_height = document.querySelector('#global-svg-'+_outId).viewBox.baseVal.height;

  // 判断是否传递数值
  let _y = option.yAxis;  // 左侧y轴样式
  let _x = option.xAxis; // 底部x轴
  let _aroundX, _aroundInX, _aroundY, _diffV, x_padding, y_padding;

  if(_x || _y) {

    _aroundX = _x.outpadding ? _x.outpadding : 12;   // x轴距离页面上下左右距离
    _aroundInX = _x.inpadding? _x.inpadding : 5; // 折线距离左右线段距离
    _aroundY = _y.padding ? _y.padding + _y.font.fontSize : 5 + _y.font.fontSize; // y轴距离页面边距左右距离
    let _aroundTextY = _y.padding ? _y.padding : 5; // y轴文字距离页面左侧的距离
    _diffV = _y.max / (_y.totalLine - 1); // 计算y轴数据之间差值
    let _x_startX = _aroundX + _aroundY + _aroundInX;  // x轴底部开始位置
    x_padding = (svg_width - _aroundX * 2 - _aroundY - _aroundInX * 2) / (option.xAxis.data.length - 1);  // 每段数据间距
    y_padding = (svg_height - _aroundX - _x.font.fontSize) / option.yAxis.totalLine;

    // y轴展示
    for (var i = 0; i < _y.totalLine; i++) {

      // 数值展示
      let _yP = (i * 1 + 1) * y_padding;
      let _yText = document.createElementNS('http://www.w3.org/2000/svg', 'text');
      _yText.setAttribute('text-anchor', 'middle');
      _yText.setAttribute('alignment-baseline', 'middle');
      _yText.setAttribute('x', _aroundTextY);
      _yText.setAttribute('y', _yP);
      _yText.setAttribute('transform', `translate(0, ${_yP * 2 }) scale(1, -1)`);
      _yText.classList.add('y-text');
      _yText.setAttribute('style', `font-size:${_countFont(_y.font.fontSize)};fill:${_y.font.color}`);
      _yText.appendChild(document.createTextNode( Math.round(i * _diffV * 100) / 100));
      document.querySelector('#global-svg-'+_outId+' #y-g').appendChild(_yText);

      // 横线
      let _yLine = document.createElementNS('http://www.w3.org/2000/svg', 'line');
      _yLine.setAttribute('x1', _aroundY + _aroundX);
      _yLine.setAttribute('y1', _yP); // y轴需要计算
      _yLine.setAttribute('x2', svg_width - _aroundX); // svg宽度 - x轴padding
      _yLine.setAttribute('y2', _yP); // y轴需要计算
      _yLine.setAttribute('stroke', `${_y.yLineColor}`);
      _yLine.setAttribute('stroke-width', '1');
      document.querySelector('#global-svg-'+_outId+' #y-g').appendChild(_yLine);
    }

    // 底部x轴样式
    for (let m in _x.data) {

    let _xText = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    _xText.setAttribute('text-anchor', 'middle');
    _xText.setAttribute('alignment-baseline', 'middle');
    _xText.setAttribute('x', _x_startX + 10);
    _xText.setAttribute('y', svg_height - y_padding + _x.font.fontSize + _aroundX);
    _xText.setAttribute('id', 'x-text-'+m);
    _xText.classList.add('x-text');
    _xText.setAttribute('style', `font-size:${_countFont(_x.font.fontSize)};fill:${_x.font.color}`);
    _xText.appendChild(document.createTextNode(_x.data[m]));
    document.querySelector('#global-svg-'+_outId+' #x-g').appendChild(_xText);

    // 折线竖线分块，实现hover选择功能
    let verticalLine = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    let endX = _x_startX + x_padding; // 计算hover区域的轴
    let endY = (_y.totalLine)* y_padding;
    let _vPath = (`M${_x_startX},${y_padding} L${_x_startX},${endY} ${endX},${endY} ${endX},${y_padding}Z`);

    verticalLine.setAttribute('fill', 'transparent');
    verticalLine.setAttribute('d',_vPath);
    verticalLine.setAttribute('class', m);
    verticalLine.setAttribute('id', 'hover-item-'+m);
    document.querySelector('#global-svg-'+_outId+' #hover-g').appendChild(verticalLine);
    verticalLine.addEventListener('mouseout', function() {
      hoverMouseout(event, m, option, outId);
    }, false);  // 鼠标移出
    verticalLine.addEventListener('mouseover', function(){
      hoverMouseover(event, m, option, outId);
    }, false);  // 鼠标移入

    _x_startX += x_padding;
  }

  }
  // 折线图、柱状图、饼状图数值及样式
  let _barArr = [];
  for(let l in option.series) {

    // 创建放入图形的g标签
    let _gPathC = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    _gPathC.classList.add('path-g-container');
    _gPathC.setAttribute('id', 'path-g-container-'+l);
    document.querySelector('#global-svg-'+_outId+' #path-g').appendChild(_gPathC);

    // 折线图、柱状图时，数据处理及展示
    if (option.series[l].type == 'line' || option.series[l].type == 'bar' ) {
      // 当type类型为bar时，重新计算柱状图之间间距
      if(option.series[l].type == 'bar') {
        x_padding = (svg_width - _aroundX * 2 - _aroundY - _aroundInX * 2 - option.series[l].normalStyle.width * option.series[l].data.length) / (option.xAxis.data.length - 1) + option.series[l].normalStyle.width // 每段数据间距
        _barArr.push(l);
      }

      let path_data = [];
      let start_x =  _aroundX + _aroundY + _aroundInX; // 折线图数据开始值，y轴间距 + x轴距离y轴的间距
      for (let s in option.series[l].data) {
        let _data = option.series[l].data;
        let _startY = y_padding * (_data[s] / _diffV) + y_padding;
        path_data.push(`${start_x},${_startY}`);

        // type为line时
        if (option.series[l].type == 'line') {
          // 折线图上圆点显示
          // hover时，竖线显示, 只生成一次，因为他们是一样的
          if (l == 0) {
            let hoverLine = document.createElementNS('http://www.w3.org/2000/svg', 'line');
            hoverLine.setAttribute('x1', start_x);
            hoverLine.setAttribute('y1', y_padding); // y轴需要计算
            hoverLine.setAttribute('x2', start_x);
            hoverLine.setAttribute('y2', (_y.totalLine) * y_padding); // y轴需要计算
            hoverLine.setAttribute('stroke', option.series[l].hoverStyle.linestroke);
            hoverLine.setAttribute('stroke-width', '1');
            hoverLine.classList.add('hover-line');
            hoverLine.classList.add('hover-line-'+s);
            document.querySelector('#global-svg-'+_outId+' #path-deploy-line-g').appendChild(hoverLine);
          }

          // 折线hover后，圆点放大
          let hoverCircle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
          hoverCircle.setAttribute('cx', start_x);
          hoverCircle.setAttribute('cy', _startY)
          hoverCircle.setAttribute('r', 5);
          hoverCircle.setAttribute('stroke', option.series[l].hoverStyle.circlestroke);
          hoverCircle.setAttribute('stroke-width', 3);
          hoverCircle.setAttribute('fill', 'none');
          hoverCircle.classList.add('hover-circle');
          hoverCircle.classList.add('hover-circle-'+s);
          document.querySelector('#global-svg-'+_outId+' #path-deploy-circle-g').appendChild(hoverCircle);


          // 折线上设置圆点
          let circle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
          circle.setAttribute('cx', start_x);
          circle.setAttribute('cy', _startY);
          circle.setAttribute('r', 3);
          circle.setAttribute('stroke', 'white');
          circle.setAttribute('stroke-width', 1);
          circle.setAttribute('fill', option.series[l].normalStyle.circlestroke);
          circle.setAttribute('transform-origin', `${start_x} ${_startY}`);  // 圆点中心位置
          circle.style.setProperty('--delay', `${(3 * parseInt(s) / _data.length)}s`);
          circle.classList.add('point');
          document.querySelector('#global-svg-'+_outId+' #path-deploy-circle-g').appendChild(circle);
        }

        // 创建柱状图
        if(option.series[l].type == 'bar') {
          createPathBar(option, l, start_x, _startY, y_padding, s, _barArr.length);
        }

        start_x += x_padding;
      }

      // 创建折线图及背景
      if (option.series[l].type == 'line') {
        createPathLine(option, l, path_data, y_padding);
      }
    }


    // 饼状图
    if(option.series[l].type == 'pie') {
      let _pieData = option.series[l].data;
      let _cx = option.series[l].style.width / 2;
      let _cy = option.series[l].style.width / 2;
      let _r = option.series[l].style.width / 2;
      let _inr = option.series[l].style.inWidth / 2; // 环行圆内部
      let _viewboxX = (svg_width - option.series[l].style.width) / 2

      document.querySelector('#global-svg-'+outId).setAttribute('viewBox', `${-_viewboxX} 100 ${svg_width} ${svg_height}`);

      // 累计饼图总大小
      let _pieTotal = 0;
      for (var o in _pieData) {
        _pieTotal += _pieData[o].value;
      }

      // 计算每个饼状图分片大小，其中角度的计算
      let _angles = [];
      let _anglesHalf = [];
      for (var o in _pieData) {
        _angles[o] = _pieData[o].value / _pieTotal * Math.PI * 2;
        _anglesHalf[o] = (_pieData[o].value / _pieTotal * Math.PI * 2) / 2;
      }

      // 遍历饼状图的每个分片
      let _startAngle = 0;
      let _outXY = [];
      let _inXY = [];
      for (var o in _pieData) {
        let _endAngle = _startAngle + _angles[o];
        let _endAngleHalf = _startAngle + _anglesHalf[o];

        let _x1 = _cx + (_r) * Math.sin(_startAngle);
        let _y1 = _cy - _r * Math.cos(_startAngle);
        let _x2 = _cx + _r * Math.sin(_endAngle);
        let _y2 = _cy - _r * Math.cos(_endAngle);

        // 环形时内圆
        let _xin1 = _cx + _inr * Math.sin(_startAngle);
        let _yin1 = _cy - _inr * Math.cos(_startAngle);
        let _xin2 = _cx + _inr * Math.sin(_endAngle);
        let _yin2 = _cy - _inr * Math.cos(_endAngle);

        let _big = _endAngle - _startAngle > Math.PI ? 1 : 0; // 小弧


        //计算线段及文字出现的位置
        let _linex = _cx + (_r) * Math.sin(_endAngleHalf);
        let _liney = _cy - (_r) * Math.cos(_endAngleHalf);
        let _linex1 = _cx + (_r + 10) * Math.sin(_endAngleHalf);
        let _liney1 = _cy - (_r + 10) * Math.cos(_endAngleHalf);
        let _linex2 = _linex < 90 ? -(_cx * 2 + _viewboxX) : _cx * 2 + _viewboxX;
        let _fontPosition = {x: _linex < 90 ? -_viewboxX : _linex2, y: _liney1, position: _linex < 90 ? 'left' : 'right'};

        console.log(_x2, '--',  _pieData[o],)
        if(option.series[l].pieType == 'separate') {
          let _fontX = _linex < 90 ? _linex + 20 : _linex - _cx / 2;

          _fontPosition = {x: _fontX , y: _liney};
        }

        // 实心圆及周边线及文字位置
        let _d, _lineD;
        if(option.series[l].pieType == 'base' || option.series[l].pieType == 'separate') {
          _d = `M${_cx} ${_cy} L${_x1} ${_y1} A${_r} ${_r} 0 ${_big} 1 ${_x2} ${_y2} Z`;
          _lineD = `M${_linex} ${_liney} L${_linex1} ${_liney1} L${_linex2} ${_liney1}`;
        }

        // 空心圆(环形)
        if(option.series[l].pieType == 'annular') {
          _d = `M${_x1} ${_y1} A${_r} ${_r} 0 ${_big} 1 ${_x2} ${_y2} L${_xin2} ${_yin2} A${_inr} ${_inr} 0 ${_big} 0 ${_xin1} ${_yin1} Z`;
        }


        // 创建圆方法
        createPathPie(l, _d, _pieData[o], _pieTotal, _lineD, _fontPosition, option, o);

        _startAngle = _endAngle; // 当前的角结束就是下一个角的开始
      }
    }
  }
}


// 创建饼状图
function createPathPie(l, d, data, total, lineD, fontPosition, option, index) {
  // 计算数值
  let _nub = Math.round(total / data.value * 100) / 100 + '%';
  // 创建饼图
  let _pie = document.createElementNS('http://www.w3.org/2000/svg', 'path');
   _pie.setAttribute('fill', data.color);
   _pie.setAttribute('d', d);
   _pie.classList.add('flex');

   // 当饼状图为分隔图时，对样式进行修改
   if (option.series[l].pieType == 'separate') {
     _pie.setAttribute('style', `transform:translate(-${index * 3}px, -${index * 5}px )`);
   }

   document.querySelector('#global-svg-'+_outId+' #path-g-container-'+l).appendChild(_pie);

   // 在分离饼状图中，显示文字
   if (option.series[l].pieType == 'separate') {
     let _pieText1 = document.createElementNS('http://www.w3.org/2000/svg', 'text');
     _pieText1.setAttribute('style', `font-size:12px;fill:#ffffff;`);
     _pieText1.appendChild(document.createTextNode(`${_nub}`));
     _pieText1.setAttribute('x', 0);
     _pieText1.setAttribute('y', 0);
     _pieText1.setAttribute('text-anchor', 'middle');
     _pieText1.setAttribute('dominant-baseline', 'central');
     _pieText1.setAttribute('transform', `translate(${fontPosition.x}, ${fontPosition.y}) scale(1, -1)`);
     document.querySelector('#global-svg-'+_outId+' #path-deploy-line-g').appendChild(_pieText1);
   }

  // 创建说明线 base
  if (lineD && option.series[l].pieType == 'base') {

    let _pieLine = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    _pieLine.setAttribute('d', lineD);
    _pieLine.setAttribute('fill', 'none');
    _pieLine.setAttribute('stroke', '#000000');  //data.color
    _pieLine.setAttribute('stroke-width', 1);
    _pieLine.setAttribute('stroke-miterlimit', 10);
    _pieLine.setAttribute('stroke-linecap', 'butt');
    document.querySelector('#global-svg-'+_outId+' #path-deploy-line-g').appendChild(_pieLine);


    // 创建文字说明

    let _pieText = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    _pieText.setAttribute('x', fontPosition.x);
    _pieText.setAttribute('y', fontPosition.y);
    _pieText.setAttribute('transform', `translate(0, ${fontPosition.y * 2+2}) scale(1, -1)`);
    _pieText.setAttribute('text-anchor', fontPosition.position == 'left' ? 'start' : 'end');
    _pieText.setAttribute('style', `font-size:12;fill:${data.color}`);
    _pieText.appendChild(document.createTextNode(`占比${_nub}`));
    document.querySelector('#global-svg-'+_outId+' #path-deploy-line-g').appendChild(_pieText);
  }
}


/*
* 创建柱状图
* option: 数据图参数
* l: series的index
* start_x: 柱状图x
* _startY: 柱状图高度
* bottomY: 柱状图距离底部x轴距离
* s: 每个柱状图index
* barNub: 柱状图类型数量
*/

function createPathBar (option, l, start_x, _startY, bottomY, s, barNub) {
  let _n;
  for (var i = 0; i < barNub; i++) {
    _n = i;
  }
  let rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
  rect.setAttribute('width', `${option.series[l].normalStyle.width}`),
  rect.setAttribute('height', _startY - bottomY);
  rect.setAttribute('x', start_x + _n * option.series[l].normalStyle.width + _n * 2);
  rect.setAttribute('y', bottomY);
  rect.setAttribute('rx', `${option.series[l].normalStyle.borderRadius}`);
  rect.setAttribute('ry', `${option.series[l].normalStyle.borderRadius}`);
  rect.setAttribute('fill', `${option.series[l].normalStyle.backgroundColor}`);
  rect.setAttribute('id', 'bar-'+l+'-'+s);
  document.querySelector('#global-svg-'+_outId+' #path-g-container-'+l).appendChild(rect);

  let _rectAnimate1 = document.createElementNS('http://www.w3.org/2000/svg', 'animate');
  _rectAnimate1.setAttribute('attributeName', 'height');
  _rectAnimate1.setAttribute('from', '0');
  _rectAnimate1.setAttribute('to', _startY - bottomY);
  _rectAnimate1.setAttribute('dur', '0.5s');
  _rectAnimate1.setAttribute('repeatCount', '1');
  // _rectAnimate1.setAttribute('fill', 'freeze');
  document.querySelector('#global-svg-'+_outId+' #bar-'+l+'-'+s).appendChild(_rectAnimate1);

  // 修改底部x轴文字位置
  document.querySelector('#global-svg-'+_outId+' #x-text-'+s).setAttribute('x', start_x + option.series[l].normalStyle.width);
}


/*
* 创建折线图
* option: 数据图参数
* l: series的index
* data: 组装数据点
* bottomY: y轴每个线段之间间距
*/
function createPathLine(option, l, data, bottomY) {

  // 折线是否平滑
  let _issmooth = option.series[l].smooth ? true : false;
  let _prefix = _issmooth ? 'R' : 'L';

  let _isPathBg = option.series[l].normalStyle.pathBgColor &&  option.series[l].normalStyle.pathBgColor != '' ? true : false;


  // 折线展示
  let line = document.createElementNS('http://www.w3.org/2000/svg', 'path');
  line.setAttribute('id', 'line-'+l);
  line.classList.add('line');
  line.setAttribute('stroke-width', '2');
  line.setAttribute('fill', 'none');
  line.setAttribute('style', `stroke:${option.series[l].normalStyle.linestroke};animation-delay:.${option.animateTime}s`);

  let _new_path_data = data;
  let startPath = _new_path_data.slice(0, 1);
  _new_path_data.splice(0, 1);

  let _line_path = (`M${startPath.join(' ')} ${_prefix}${_new_path_data.join(' ')}`);
  let _newPath = _issmooth ? parsePath(_line_path) : _line_path;
  line.setAttribute('d', _newPath);
  document.querySelector('#global-svg-'+_outId+' #path-g-container-'+l).appendChild(line);

  // 折线图背景色数值
  if (_isPathBg) {
    let line_bg = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    line_bg.setAttribute('id', 'line-1-'+l);
    line_bg.classList.add('line-1');
    line_bg.setAttribute('fill', `${'url("#line-bg-'+l+'")'}`);
    let path_end = _new_path_data[_new_path_data.length - 1].split(',')
    let path_start = startPath.join(',').split(',');
    // 组新数据
    let bg_path = (`M${startPath.join(' ')} ${_prefix}${_new_path_data.join(' ')} H${path_end[0]}V${bottomY}H${path_start[0]}Z`);
    let _newBgPath = _issmooth ? parsePath(bg_path) : bg_path;
    line_bg.setAttribute('d', _newBgPath);
    document.querySelector('#global-svg-'+_outId+' #path-bg-g').appendChild(line_bg);


    // 创建折线图显示背景颜色标签
    // let _linearTime = setTimeout(() => {
      creatLinearGradient('line-bg-'+l, option.series[l].normalStyle.pathBgColor, l);
    //   clearTimeout(_linearTime);
    // }, 1000 * 3);
  }

  // //计算长度，实现动画
  let strokeLength = Math.ceil(document.querySelector('#global-svg-'+_outId+' #line-'+l).getTotalLength());  //获取折线图的长度
  document.querySelector('#global-svg-'+_outId+' #path-g-container-'+l).style.setProperty('--stroke-length', strokeLength);
  document.querySelector('#global-svg-'+_outId).classList.add('animate');
}

// 折线图背景色显示的标签位置
function creatLinearGradient(id, bgColor, l) {
  // 背景外层
  let _linear = document.createElementNS('http://www.w3.org/2000/svg', 'linearGradient');
  _linear.setAttribute('id', id);
  _linear.setAttribute('x1', '0%');
  _linear.setAttribute('x2', '0%');
  _linear.setAttribute('y1', '0%');
  _linear.setAttribute('y2', '100%');
  // _linear.setAttribute('style', 'fill-opacity: 0');
  document.querySelector('#global-svg-'+_outId+' #path-bg-color-g').appendChild(_linear);

  // 背景颜色
  let _colorData = [
    {offset: "0", stopColor: bgColor, stopOpacity: '0'},
    {offset: "1", stopColor: bgColor, stopOpacity: '0'}
  ];

  for (let k in _colorData) {
    let _stop = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
    _stop.setAttribute('offset', _colorData[k].offset);
    _stop.setAttribute('stop-color', _colorData[k].stopColor);
    _stop.setAttribute('stop-opacity', _colorData[k].stopOpacity);
    _stop.setAttribute('id', 'stop-'+l+'-'+k);
    _linear.appendChild(_stop);

  }

  // 背景动画
  let _bgAnimate1 = document.createElementNS('http://www.w3.org/2000/svg', 'animate');
  _bgAnimate1.setAttribute('attributeName', 'y1');
  _bgAnimate1.setAttribute('from', '1');
  _bgAnimate1.setAttribute('to', '0');
  _bgAnimate1.setAttribute('dur', '0.3s');
  _bgAnimate1.setAttribute('begin', `${option.animateTime}s`);
  _bgAnimate1.setAttribute('repeatCount', '1');
  _bgAnimate1.setAttribute('fill', 'freeze');
  _linear.appendChild(_bgAnimate1);

  let _bgAnimate = document.createElementNS('http://www.w3.org/2000/svg', 'animate');
  _bgAnimate.setAttribute('attributeName', 'stop-opacity');
  _bgAnimate.setAttribute('from', '0.5');
  _bgAnimate.setAttribute('to', '0');
  _bgAnimate.setAttribute('dur', '0s');
  _bgAnimate.setAttribute('begin', `${option.animateTime}s`);
  _bgAnimate.setAttribute('repeatCount', '1');
  _bgAnimate.setAttribute('fill', 'freeze');
  // _stop.appendChild(_bgAnimate);
  document.querySelector('#global-svg-'+_outId+' #stop-'+l +'-1').appendChild(_bgAnimate);

}

// 数字换算
function _countFont(fontSize) {
  let _diff = diffValue;
  return fontSize;
}

// 鼠标移出
function hoverMouseout(event, s, option, outId) {
  let _allEl = document.querySelector('#global-svg-'+outId).querySelectorAll('.hover-circle-' +s);
  if (_allEl.length > 0) {
    for (var i = 0; i < _allEl.length; i++) {
      _allEl[i].style.setProperty('opacity', 0);
    }
    document.querySelector('#global-svg-'+outId).querySelector('.hover-line-' +s).style.setProperty('opacity', 0);
    document.querySelector('#global-svg-'+outId).querySelector('#x-text-'+s).style.setProperty('fill', option.xAxis.font.color);
  }
}

// 鼠标移入
function hoverMouseover(event, s, option, outId) {
  let _allEl = document.querySelector('#global-svg-'+outId).querySelectorAll('.hover-circle-' +s);

  if (_allEl.length > 0) {
    for (var i = 0; i < _allEl.length; i++) {
      _allEl[i].style.setProperty('opacity', 1);
    }
    document.querySelector('#global-svg-'+outId).querySelector('.hover-line-' +s).style.setProperty('opacity', 1);
    document.querySelector('#global-svg-'+outId).querySelector('#x-text-'+s).style.setProperty('fill', option.xAxis.font.hoverFontColor);
  }
}


//计算path值
function parsePath( data ) {

  var pathArray = [];
  var lastX = "";
  var lastY = "";
  var d = data.toString();

  if ( -1 != d.search(/[rR]/) ) {
    // no need to redraw the path if no Catmull-Rom segments are found

    // split path into constituent segments
    var pathSplit = d.split(/([A-Za-z])/);
    for (var i = 0, iLen = pathSplit.length; iLen > i; i++) {
      var segment = pathSplit[i];

      // make command code lower case, for easier matching
      // NOTE: this code assumes absolution coordinates, and doesn't account for relative command coordinates
      var command = segment.toLowerCase()
      if ( -1 != segment.search(/[A-Za-z]/) ) {
        var val = "";
        if ( "z" != command ) {
          i++;
          val = pathSplit[ i ].replace(/\s+$/, '');
        }

        if ( "r" == command ) {
          // "R" and "r" are the a Catmull-Rom spline segment

          var points = lastX + "," + lastY + " " + val;

          // convert Catmull-Rom spline to B茅zier curves
          var beziers = catmullRom2bezier( points );
          //insert replacement curves back into array of path segments
          pathArray.push( beziers );
        } else {
          // rejoin the command code and the numerical values, place in array of path segments
          pathArray.push( segment + val );

          // find last x,y points, for feeding into Catmull-Rom conversion algorithm
          if ( "h" == command ) {
            lastX = val;
          } else if ( "v" == command ) {
            lastY = val;
          } else if ( "z" != command ) {
            var c = val.split(/[,\s]/);
            lastY = c.pop();
            lastX = c.pop();
          }
        }
      }
    }

    // recombine path segments and set new path description in DOM
    // path.setAttribute( "d", pathArray.join(" ") );
    return pathArray;
  }
}


function catmullRom2bezier( points ) {
  // alert(points)
  var crp = points.split(/[,\s]/);

  var d = "";
  for (var i = 0, iLen = crp.length; iLen - 2 > i; i+=2) {
    var p = [];
    if ( 0 == i ) {
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
      p.push( {x: parseFloat(crp[ i + 4 ]), y: parseFloat(crp[ i + 5 ])} );
    } else if ( iLen - 4 == i ) {
      p.push( {x: parseFloat(crp[ i - 2 ]), y: parseFloat(crp[ i - 1 ])} );
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
    } else {
      p.push( {x: parseFloat(crp[ i - 2 ]), y: parseFloat(crp[ i - 1 ])} );
      p.push( {x: parseFloat(crp[ i ]), y: parseFloat(crp[ i + 1 ])} );
      p.push( {x: parseFloat(crp[ i + 2 ]), y: parseFloat(crp[ i + 3 ])} );
      p.push( {x: parseFloat(crp[ i + 4 ]), y: parseFloat(crp[ i + 5 ])} );
    }

    // Catmull-Rom to Cubic Bezier conversion matrix
    //    0       1       0       0
    //  -1/6      1      1/6      0
    //    0      1/6      1     -1/6
    //    0       0       1       0

    var bp = [];
    bp.push( { x: p[1].x,  y: p[1].y } );
    bp.push( { x: ((-p[0].x + 6*p[1].x + p[2].x) / 6), y: ((-p[0].y + 6*p[1].y + p[2].y) / 6)} );
    bp.push( { x: ((p[1].x + 6*p[2].x - p[3].x) / 6),  y: ((p[1].y + 6*p[2].y - p[3].y) / 6) } );
    bp.push( { x: p[2].x,  y: p[2].y } );

    d += "C" + bp[1].x + "," + bp[1].y + " " + bp[2].x + "," + bp[2].y + " " + bp[3].x + "," + bp[3].y + " ";
  }

  return d;
}
